/*
  WS2812FX.h - Library for WS2812 LED effects.

  Harm Aldick - 2016
  www.aldick.org

  2017-04-10   CAL - Added new modes: OFF, AUTO, LINES, LINES_RANDOM
  2021-12-20   CAL major changes for TriLight
  2021-12-24   CAL - Removed Crazy Light modes and added new modes for TriLight
*/

#ifndef WS2812FX_h
#define WS2812FX_h

#include <Adafruit_NeoPixel.h>

#define DEFAULT_BRIGHTNESS 32
#define DEFAULT_MODE 0
#define DEFAULT_SPEED 150
#define DEFAULT_COLOR 0xFF0000

#define SPEED_MIN 0
#define SPEED_MAX 255

#define BRIGHTNESS_MIN 0
#define BRIGHTNESS_MAX 255

#define AUTO_CHANGE_DELAY_SECS    30	// CAL
#define AUTO_CHANGE_DELAY_MS     (AUTO_CHANGE_DELAY_SECS * 1000) // CAL

// Auto timeout of auto mode
#define AUTO_TIMEOUT_MINS        (15)
#define AUTO_TIMEOUT_SECS        (AUTO_TIMEOUT_MINS * 60)
#define AUTO_TIMEOUT_MS          (AUTO_TIMEOUT_SECS * 1000)

#define MODE_COUNT 36

#define FX_MODE_OFF                      0
#define FX_MODE_AUTO                     1
#define FX_MODE_STATIC                   2
#define FX_MODE_BREATH                   3
#define FX_MODE_COLOR_WIPE               4
#define FX_MODE_COLOR_WIPE_RANDOM        5
#define FX_MODE_RANDOM_COLOR             6
#define FX_MODE_MULTI_DYNAMIC            7
#define FX_MODE_RAINBOW                  8
#define FX_MODE_RAINBOW_CYCLE            9
#define FX_MODE_THEATER_CHASE           10
#define FX_MODE_THEATER_CHASE_RAINBOW   11
#define FX_MODE_RUNNING_LIGHTS          12
#define FX_MODE_TWINKLE_RANDOM          13
#define FX_MODE_TWINKLE_FADE            14
#define FX_MODE_TWINKLE_FADE_RANDOM     15
#define FX_MODE_FLASH_SPARKLE           16
#define FX_MODE_CHASE_WHITE             17
#define FX_MODE_CHASE_COLOR             18
#define FX_MODE_CHASE_RANDOM            19
#define FX_MODE_CHASE_RAINBOW           20
#define FX_MODE_CHASE_FLASH_RANDOM      21
#define FX_MODE_CHASE_BLACKOUT          22
#define FX_MODE_CHASE_BLACKOUT_RAINBOW  23
#define FX_MODE_COLOR_SWEEP_RANDOM      24
#define FX_MODE_RUNNING_RED_BLUE        25
#define FX_MODE_RUNNING_RANDOM          26
#define FX_MODE_FIREWORKS               27
#define FX_MODE_FIREWORKS_RANDOM        28
#define FX_MODE_MERRY_CHRISTMAS         29
#define FX_MODE_FIRE_FLICKER            30
#define FX_MODE_PERIMETER               31
#define FX_MODE_PERIMETER_RANDOM        32
#define FX_MODE_DIAGS                   33
#define FX_MODE_INWARD                  34
#define FX_MODE_TRIANGLES               35

class WS2812FX : public Adafruit_NeoPixel {

    typedef void (WS2812FX::*mode_ptr)(void);

  public:

    WS2812FX(uint16_t n, uint8_t p, neoPixelType t) : Adafruit_NeoPixel(n, p, t) {
      _mode[FX_MODE_OFF]                   = &WS2812FX::mode_off;
      _mode[FX_MODE_AUTO]                  = &WS2812FX::mode_auto;
      _mode[FX_MODE_STATIC]                = &WS2812FX::mode_static;
      _mode[FX_MODE_BREATH]                = &WS2812FX::mode_breath;
      _mode[FX_MODE_COLOR_WIPE]            = &WS2812FX::mode_color_wipe;
      _mode[FX_MODE_COLOR_WIPE_RANDOM]     = &WS2812FX::mode_color_wipe_random;
      _mode[FX_MODE_RANDOM_COLOR]          = &WS2812FX::mode_random_color;
      _mode[FX_MODE_MULTI_DYNAMIC]         = &WS2812FX::mode_multi_dynamic;
      _mode[FX_MODE_RAINBOW]               = &WS2812FX::mode_rainbow;
      _mode[FX_MODE_RAINBOW_CYCLE]         = &WS2812FX::mode_rainbow_cycle;
      _mode[FX_MODE_THEATER_CHASE]         = &WS2812FX::mode_theater_chase;
      _mode[FX_MODE_THEATER_CHASE_RAINBOW] = &WS2812FX::mode_theater_chase_rainbow;
      _mode[FX_MODE_RUNNING_LIGHTS]        = &WS2812FX::mode_running_lights;
      _mode[FX_MODE_TWINKLE_RANDOM]        = &WS2812FX::mode_twinkle_random;
      _mode[FX_MODE_TWINKLE_FADE]          = &WS2812FX::mode_twinkle_fade;
      _mode[FX_MODE_TWINKLE_FADE_RANDOM]   = &WS2812FX::mode_twinkle_fade_random;
      _mode[FX_MODE_FLASH_SPARKLE]         = &WS2812FX::mode_flash_sparkle;
      _mode[FX_MODE_CHASE_WHITE]           = &WS2812FX::mode_chase_white;
      _mode[FX_MODE_CHASE_COLOR]           = &WS2812FX::mode_chase_color;
      _mode[FX_MODE_CHASE_RANDOM]          = &WS2812FX::mode_chase_random;
      _mode[FX_MODE_CHASE_RAINBOW]         = &WS2812FX::mode_chase_rainbow;
      _mode[FX_MODE_CHASE_FLASH_RANDOM]    = &WS2812FX::mode_chase_flash_random;
      _mode[FX_MODE_CHASE_BLACKOUT]        = &WS2812FX::mode_chase_blackout;
      _mode[FX_MODE_CHASE_BLACKOUT_RAINBOW] = &WS2812FX::mode_chase_blackout_rainbow;
      _mode[FX_MODE_COLOR_SWEEP_RANDOM]    = &WS2812FX::mode_color_sweep_random;
      _mode[FX_MODE_RUNNING_RED_BLUE]      = &WS2812FX::mode_running_red_blue;
      _mode[FX_MODE_RUNNING_RANDOM]        = &WS2812FX::mode_running_random;
      _mode[FX_MODE_FIREWORKS]             = &WS2812FX::mode_fireworks;
      _mode[FX_MODE_FIREWORKS_RANDOM]      = &WS2812FX::mode_fireworks_random;
      _mode[FX_MODE_MERRY_CHRISTMAS]       = &WS2812FX::mode_merry_christmas;
      _mode[FX_MODE_FIRE_FLICKER]          = &WS2812FX::mode_fire_flicker;
      _mode[FX_MODE_PERIMETER]             = &WS2812FX::mode_perimeter;
      _mode[FX_MODE_PERIMETER_RANDOM]      = &WS2812FX::mode_perimeter_random;
      _mode[FX_MODE_DIAGS]                 = &WS2812FX::mode_diags;
      _mode[FX_MODE_INWARD]                = &WS2812FX::mode_inward;
      _mode[FX_MODE_TRIANGLES]             = &WS2812FX::mode_triangles;

      _name[FX_MODE_OFF]                   = "Off";
      _name[FX_MODE_AUTO]                  = "Auto";
      _name[FX_MODE_STATIC]                = "Static";
      _name[FX_MODE_BREATH]                = "Breath";
      _name[FX_MODE_COLOR_WIPE]            = "Color Wipe";
      _name[FX_MODE_COLOR_WIPE_RANDOM]     = "Color Wipe Random";
      _name[FX_MODE_RANDOM_COLOR]          = "Random Color";
      _name[FX_MODE_MULTI_DYNAMIC]         = "Dynamics";
      _name[FX_MODE_RAINBOW]               = "Rainbow";
      _name[FX_MODE_RAINBOW_CYCLE]         = "Rainbow Cycle";
      _name[FX_MODE_THEATER_CHASE]         = "Theater Chase";
      _name[FX_MODE_THEATER_CHASE_RAINBOW] = "Theater Chase Rainbow";
      _name[FX_MODE_RUNNING_LIGHTS]        = "Running Lights";
      _name[FX_MODE_TWINKLE_RANDOM]        = "Twinkle Random";
      _name[FX_MODE_TWINKLE_FADE]          = "Twinkle Fade";
      _name[FX_MODE_TWINKLE_FADE_RANDOM]   = "Twinkle Fade Random";
      _name[FX_MODE_FLASH_SPARKLE]         = "Flash Sparkle";
      _name[FX_MODE_CHASE_WHITE]           = "Chase White";
      _name[FX_MODE_CHASE_COLOR]           = "Chase Color";
      _name[FX_MODE_CHASE_RANDOM]          = "Chase Random";
      _name[FX_MODE_CHASE_RAINBOW]         = "Chase Rainbow";
      _name[FX_MODE_CHASE_FLASH_RANDOM]    = "Chase Flash Random";
      _name[FX_MODE_CHASE_BLACKOUT]        = "Chase Blackout";
      _name[FX_MODE_CHASE_BLACKOUT_RAINBOW] = "Chase Blackout Rainbow";
      _name[FX_MODE_COLOR_SWEEP_RANDOM]    = "Color Sweep Random";
      _name[FX_MODE_RUNNING_RED_BLUE]      = "Running Red Blue";
      _name[FX_MODE_RUNNING_RANDOM]        = "Running Random";
      _name[FX_MODE_FIREWORKS]             = "Fireworks";
      _name[FX_MODE_FIREWORKS_RANDOM]      = "Fireworks Random";
      _name[FX_MODE_MERRY_CHRISTMAS]       = "Merry Christmas";
      _name[FX_MODE_FIRE_FLICKER]          = "Fire";
      _name[FX_MODE_PERIMETER]             = "Perimeter";
      _name[FX_MODE_PERIMETER_RANDOM]      = "Perimeter Random";
      _name[FX_MODE_DIAGS]                 = "Diagonals";
      _name[FX_MODE_INWARD]                = "Inward";
      _name[FX_MODE_TRIANGLES]             = "Triangles";

      _mode_index = DEFAULT_MODE;
      _speed = DEFAULT_SPEED;
      _brightness = DEFAULT_BRIGHTNESS;
      _running = false;
      _led_count = n;
      _mode_last_call_time = 0;
      _mode_delay = 0;
      _color = DEFAULT_COLOR;
      _mode_color = DEFAULT_COLOR;
      _counter_mode_call = 0;
      _counter_mode_step = 0;
    }
    void init(void);
    void service(void);
    void start(void);
    void stop(void);
    void setMode(uint8_t m);
    void setSpeed(uint8_t s);
    void increaseSpeed(uint8_t s);
    void decreaseSpeed(uint8_t s);
    void setColor(uint8_t r, uint8_t g, uint8_t b);
    void setColor(uint32_t c);
    void setBrightness(uint8_t b);
    void increaseBrightness(uint8_t s);
    void decreaseBrightness(uint8_t s);
    void trigger(void);

    boolean isRunning(void);

    uint8_t getMode(void);
    uint8_t getSpeed(void);
    uint8_t getBrightness(void);
    uint8_t getModeCount(void);

    uint32_t getColor(void);

    const char* getModeName(uint8_t m);

  private:

    void strip_off(void);
    void mode_off(void);
    void mode_auto(void);
    void mode_static(void);
    void mode_breath(void);
    void mode_color_wipe(void);
    void mode_color_wipe_random(void);
    void mode_random_color(void);
    void mode_multi_dynamic(void);
    void mode_theater_chase(void);
    void mode_theater_chase_rainbow(void);
    void mode_rainbow(void);
    void mode_rainbow_cycle(void);
    void mode_running_lights(void);
    void mode_twinkle_random(void);
    void mode_twinkle_fade(void);
    void mode_twinkle_fade_random(void);
    void mode_flash_sparkle(void);
    void mode_multi_strobe(void);
    void mode_chase_white(void);
    void mode_chase_color(void);
    void mode_chase_random(void);
    void mode_chase_rainbow(void);
    void mode_chase_flash_random(void);
    void mode_chase_blackout(void);
    void mode_chase_blackout_rainbow(void);
    void mode_color_sweep_random(void);
    void mode_running_red_blue(void);
    void mode_running_random(void);
    void mode_fireworks(void);
    void mode_fireworks_random(void);
    void mode_merry_christmas(void);
    void mode_fire_flicker(void);
    void mode_fire_flicker_int(int);

    // CAL - Start
    void mode_perimeter(void);
    void mode_perimeter_random(void);
    void mode_diags(void);
    void mode_inward(void);
    void mode_triangles(void);

    void drawATriangle(int num, uint32_t color);

    bool _auto_mode;
    int  _inc;
    unsigned long _autoTimeout;
    unsigned long _auto_mode_change_time;
    // CAL - End

    bool _running;

    uint8_t get_random_wheel_index(uint8_t);
    uint8_t _mode_index;
    uint8_t _speed;
    uint8_t _brightness;

    uint16_t _led_count;

    uint32_t color_wheel(uint8_t);
    uint32_t _color;
    uint32_t _counter_mode_call;
    uint32_t _counter_mode_step;
    uint32_t _mode_color;
    uint32_t _mode_delay;

    unsigned long _mode_last_call_time;

    const char* _name[MODE_COUNT];

    mode_ptr _mode[MODE_COUNT];
};

#endif
