/*
   Spiral Lamp PIR Sensor Support
        
   Measurements in millimeters
   
   Concept, Design and Implementation: Craig A. Lindley
   Last Update: 02/05/2025
*/


$fa = 1;
$fs = 0.4;
 
INCHES_TO_MM = 25.4;

WALL_THICKNESS = 1.0;

ROTATE_ANGLE = 30;

// Component dimensions
PIR_HOLE_DIAMETER = 0.45 * INCHES_TO_MM;

PIR_BOX_WIDTH  = 1.0  * INCHES_TO_MM; // X
PIR_BOX_HEIGHT = 0.75 * INCHES_TO_MM; // Z
PIR_BOX_LENGTH = 2.0  * INCHES_TO_MM; // Y

// Pushbutton switch dimensions
PB_WIDTH  = 0.24 * INCHES_TO_MM;
PB_HEIGHT = 0.24 * INCHES_TO_MM;

// Base dimensions
INSIDE_WIDTH  = PIR_BOX_WIDTH;
INSIDE_HEIGHT = PIR_BOX_HEIGHT;
INSIDE_LENGTH = PIR_BOX_LENGTH; 

OUTSIDE_WIDTH  = INSIDE_WIDTH  + (2.0 * WALL_THICKNESS);
OUTSIDE_HEIGHT = INSIDE_HEIGHT + (2.0 * WALL_THICKNESS);
OUTSIDE_LENGTH = INSIDE_LENGTH + (2.0 * WALL_THICKNESS);


module PIR_Hole() {
  rotate([90, 0, 0]) { 
    cylinder(h = INSIDE_LENGTH, d = PIR_HOLE_DIAMETER, center = true);
  }
}


module Box() {
  difference() {
      
    cube([OUTSIDE_WIDTH, OUTSIDE_LENGTH, OUTSIDE_HEIGHT], center=true);
    
    translate([0, 0, -1.0 * WALL_THICKNESS]) {
      cube([INSIDE_WIDTH, INSIDE_LENGTH, OUTSIDE_HEIGHT], center=true);
    }
    
    translate([0, -10, 0]) {
      PIR_Hole();
    } 
    
    cube([PB_WIDTH, PB_HEIGHT, 30], center = true);
  }
}


module RotatedBox() {
  rotate([-ROTATE_ANGLE, 0, 0]) {
    Box();
  }
}

module ClipBox() {
  cube([OUTSIDE_WIDTH * 2, OUTSIDE_LENGTH * 2, OUTSIDE_HEIGHT * 2], center=true);
}

module PIR_Support() {
  difference() {
    RotatedBox();
    translate([0, 0, -17]) {
      ClipBox();   
    }
  }
}
  
  



PIR_Support();







