/*
   Spiral Lamp Housing
        
   Measurements in millimeters
   
   Concept, Design and Implementation: Craig A. Lindley
   Last Update: 02/06/2025
*/


$fa = 1;
$fs = 0.4;
 
INCHES_TO_MM = 25.4;

WALL_THICKNESS = 1.0;

HOUSING_OUTSIDE_DIAMETER = 2.25 * INCHES_TO_MM;
HOUSING_INSIDE_DIAMETER  = HOUSING_OUTSIDE_DIAMETER - (2.0 * WALL_THICKNESS);

HOUSING_HEIGHT = 1.5 * INCHES_TO_MM;

// Push In Nut
PIN_DIAMETER = 0.2 * INCHES_TO_MM;

// Pref Board Hole Dimensions
PBOARD_WIDTH  = 1.1 * INCHES_TO_MM;
PBOARD_LENGTH = 1.5 * INCHES_TO_MM;

// USB Cable Hole
USB_WIDTH  = 0.5  * INCHES_TO_MM;
USB_HEIGHT = 0.5  * INCHES_TO_MM;
USB_VOFFSET = 7.0 / 8.0 * INCHES_TO_MM;

module USBHole() {
  cube([3.0 * INCHES_TO_MM, USB_WIDTH, USB_HEIGHT], center = true);
}


module RawHousing() {
  difference() {
      
    cylinder(h = HOUSING_HEIGHT, d = HOUSING_OUTSIDE_DIAMETER);
    translate([0, 0, WALL_THICKNESS]) {
      cylinder(h = HOUSING_HEIGHT, d = HOUSING_INSIDE_DIAMETER);
    }
    // Rect hole cutout
    cube([1.25 * INCHES_TO_MM, 0.75 * INCHES_TO_MM, 5 * WALL_THICKNESS], center = true);
  }  
}

 
module NutSupport() {
  translate([0, 0, HOUSING_HEIGHT - (0.25 * INCHES_TO_MM)]) {
    difference() {
      cylinder(h = 0.5 * INCHES_TO_MM, d = 0.3  * INCHES_TO_MM, center = true);
      cylinder(h = 1.2 * INCHES_TO_MM, d = 0.15 * INCHES_TO_MM, center = true);
    }
  }
}

module PBoardSupport() {
  translate([0, 0, (0.25 * INCHES_TO_MM) + WALL_THICKNESS]) {
    difference() {
      cylinder(h = 0.5 * INCHES_TO_MM, d = 0.25 * INCHES_TO_MM, center = true);
      cylinder(h = 1.2 * INCHES_TO_MM, d = 0.10 * INCHES_TO_MM, center = true);
    }
  }
}

module HousingWithSupports() {
  difference() {
    RawHousing();
    translate([-15, 0, USB_VOFFSET]) {
      USBHole();
    }
  }

  // Mounting supports
  translate([0, -0.975 * INCHES_TO_MM, 0]) {
    NutSupport();
  }
  translate([0, +0.975 * INCHES_TO_MM, 0]) {
    NutSupport();
  }
  
  // Pref board supports
  translate([-PBOARD_WIDTH / 2.0, -PBOARD_LENGTH / 2.0, 0]) {
    PBoardSupport();
  }
  translate([+PBOARD_WIDTH / 2.0, -PBOARD_LENGTH / 2.0, 0]) {
    PBoardSupport();
  }
  translate([-PBOARD_WIDTH / 2.0, +PBOARD_LENGTH / 2.0, 0]) {
    PBoardSupport();
  }
  translate([+PBOARD_WIDTH / 2.0, +PBOARD_LENGTH / 2.0, 0]) {
    PBoardSupport();
  }
  
    
    
    
}

HousingWithSupports();





