/*
   Spiral Lamp ESP32 Support
        
   Measurements use millimeters
   
   Concept, Design and Implementation: Craig A. Lindley
   Last Update: 02/06/2025
*/


$fa = 1;
$fs = 0.4;
 
INCHES_TO_MM = 25.4;

BOARD_THICKNESS = 3.0;

SCREW_HOLE_DIAMETER =  3.0;
SIDE_CUT_DIAMETER   = 10.0;

// Support board dimensions
PB_WIDTH  = 1.4 * INCHES_TO_MM;
PB_LENGTH = 1.9 * INCHES_TO_MM;

// Pref board hole dimensions
PBOARD_HOLE_WIDTH  = 1.1 * INCHES_TO_MM;
PBOARD_HOLE_LENGTH = 1.5 * INCHES_TO_MM;

// Slot for ESP32 pins
PSLOT_WIDTH = 1.0 * INCHES_TO_MM;
PSLOT_DEPTH = 2.0;

module slab() {
  cube([PB_WIDTH, PB_LENGTH, BOARD_THICKNESS], center = true);
}

module screwHole() {
  cylinder(h = 10, d = SCREW_HOLE_DIAMETER, center = true);
}

module sideCut() {
  cylinder(h = 10, d = SIDE_CUT_DIAMETER, center = true);
}

module pinSlot() {
  cube([PSLOT_WIDTH, PSLOT_DEPTH, 10], center = true);
}

module slabWithHoles() {
  difference() {
    slab();
      
    // Mounting holes
    translate([-PBOARD_HOLE_WIDTH / 2.0, -PBOARD_HOLE_LENGTH / 2.0  ]) {  
      screwHole();
    }
    translate([+PBOARD_HOLE_WIDTH / 2.0, -PBOARD_HOLE_LENGTH / 2.0  ]) {  
      screwHole();
    }
    translate([-PBOARD_HOLE_WIDTH / 2.0, +PBOARD_HOLE_LENGTH / 2.0  ]) {  
      screwHole();
    }
    translate([+PBOARD_HOLE_WIDTH / 2.0, +PBOARD_HOLE_LENGTH / 2.0  ]) {  
      screwHole();
    }
    
    // Side cuts
    translate([0, -PB_LENGTH / 2.0, 0]) {
      sideCut();
    }
    translate([0, +PB_LENGTH / 2.0, 0]) {
      sideCut();
    }
    
    // Pin slots
    translate([-3, -1.1 / 2.0 * INCHES_TO_MM, 0]) {
      pinSlot();
    }
    translate([-3, 1.1 / 2.0 * INCHES_TO_MM, 0]) {
      pinSlot();
    }
      
  }
}
  

slabWithHoles();
